# MFF DS

Materials for Data Science course NDBI048 teached at MFF UK.

## Setup

#### Prerequisities

- [Git](https://git-scm.com/book/en/v2/Getting-Started-Installing-Git) for having up-to-date materials
- Git LFS to version large files: `git lfs install`
- [uv](https://docs.astral.sh/uv/getting-started/installation/#standalone-installer) as a dependency manager will allow us to quicky add dependencies as course proceeds
- [VS code](https://code.visualstudio.com/) as recommended IDE 

Following steps can be done in your favourite terminal (e.g. Windows: Powershell / Git Bash, Linux: bash).

#### Clone repo
```
git clone <repository URL>
cd <repo name>
```



#### Sync dependencies
```
uv sync
```
This creates `.venv` you can use as a kernel in Jupyter notebooks.

If this fails, you probably don't have compatible Python version. Install chosen version (using uv) and try sync again:
```
uv python install <selected compatible version>
uv sync
```

Repeat sync after each `git pull`, dependencies will change as course proceeds!

#### Open in VS code

Run VS code and open folder where the repo was cloned. Recommended extensions to be installed (may leave for later):

- Python
- Jupyter


## Dev setup

Std. setup plus extras below.

#### Quarto

- Install Quarto
- Intall extension for TeX: `quarto install tinytex`
- Install extension for Profinit template: `quarto add profinit/quarto-templates`

#### Adding deps

Call `uv add <packagename>` whenever you need new package. This will add it to `pyproject.toml`, update `uv.lock` and install it with dependency resolvement. For alternatives see [official documentation](https://docs.astral.sh/uv/guides/projects/#managing-dependencies). 
